Attribute VB_Name = "mdMakeParallel"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to make a set of lines parallel

Sub MakeParallel(lineSet As ObjectSet)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim newlines As ObjectSet
Set newlines = app.GetClass("ObjectSet").CreateAObjectSet

Dim wp As aWorkplane
Set wp = lineSet.GetAnyMember.GetParent("Workplane")

Dim it As Iterator
Set it = app.GetClass("It").CreateAObjectIt(lineSet)

Dim lineSetCollection As New Collection
it.start
Do While it.IsActive
    lineSetCollection.Add Item:=it.Current
    it.Next
Loop

Set line = lineSetCollection.Item(1)

newlines.AddMember line

For I = 2 To lineSetCollection.count
    
    Set line = lineSetCollection.Item(I)

    For j = 1 To lineSetCollection.count
        
        Set otherline = lineSetCollection.Item(j)
        Dim zcon As zConstraintDef
        Set zcon = app.GetClass("Parallel").CreateParallel(line, otherline)
        
        If (wp.GetConstraint(zcon) Is Nothing) Then
            wp.CreateConstraint zcon
        Else
            Set acon = wp.GetConstraint(zcon)
            acon.Delete
            
        End If
        
    
    Next j

    newlines.AddMember line

Next I

End Sub




